﻿using System;
using System.Diagnostics;
using System.Net;
using System.Net.Sockets;
using System.Threading;
using FyndSharp.Utilities.Common;

namespace gov.va.med.VBECS.Communication.Channels
{
    internal class TcpConnectionListener : BaseListener
    {
        /// <summary>
        /// The endpoint address of the server to listen incoming connections.
        /// </summary>
        private readonly IPEndPoint _endPoint;

        /// <summary>
        /// A flag to control thread's running
        /// </summary>
        private volatile bool _isRunning;

        /// <summary>
        /// Server socket to listen incoming connection requests.
        /// </summary>
        private TcpListener _listenerSocket;

        /// <summary>
        /// The thread to listen socket
        /// </summary>
        private Thread _thread;

        /// <summary>
        /// Creates a new TcpConnectionListener for given endpoint.
        /// </summary>
        /// <param name="theEndPoint">The endpoint address of the server to listen incoming connections</param>
        public TcpConnectionListener(IPEndPoint theEndPoint)
        {
            Checker.NotNull(theEndPoint);
            _endPoint = theEndPoint;
        }

        public override void Start()
        {
            start_socket();
            _isRunning = true;
            _thread = new Thread(accept_connection);
            _thread.Start();
        }

        public override void Stop()
        {
            _isRunning = false;
            stop_socket();
        }

        /// <summary>
        /// Starts listening socket.
        /// </summary>
        private void start_socket()
        {
            _listenerSocket = new TcpListener(_endPoint);
            _listenerSocket.Start();
        }

        /// <summary>
        /// Stops listening socket.
        /// </summary>
        private void stop_socket()
        {
            try
            {
                _listenerSocket.Stop();
            }
#if TRACE
            catch (Exception e)
            {
                Trace.WriteLine(e.ToString());
            }
#else
            catch { }
#endif
        }

        /// <summary>
        /// Entrance point of the thread.
        /// This method is used by the thread to listen incoming requests.
        /// </summary>
        private void accept_connection()
        {
            while (_isRunning)
            {
                try
                {
                    Socket aClientSocket = _listenerSocket.AcceptSocket();
                    if (aClientSocket.Connected)
                    {
                        FireChannelConnectedEvent(new TcpChannel(aClientSocket));
                    }
                }
#if TRACE
                catch (Exception ex1)
#else
                catch
#endif
                {
#if TRACE
                    Trace.WriteLine(ex1.ToString());
#endif
                    //Disconnect, wait for a while and connect again.
                    stop_socket();
                    Thread.Sleep(1000);
                    if (!_isRunning)
                    {
                        return;
                    }

                    try
                    {
                        start_socket();
                    }
#if TRACE
                    catch (Exception ex2)
                    {
                        Trace.WriteLine(ex2.ToString());
                    }
#else
                    catch { }
#endif
                }
            }
        }
    }
}